#include <iostream>

#include "Level.h"

#include "MainMenu.h"
#include "HowToPlay.h"
#include "Lives.h"
#include "MainGame.h"
#include "GameOver.h"
#include "TimeUp.h"
#include "YouWin.h"

using namespace std;

MainGame* game;	//
MainMenu* menus;	//
Lives* lives;	//
HowToPlay* howToPlay;	//		Create pointers to all of our levels
GameOver* over;	//
TimeUp* up;	//
YouWin* win;	//

Level* Level::QueryLevel(LevelType whichLevel)	//QueryLevel returns the Level pointer object so we can change Levels
{
	switch (whichLevel) 
	{
		case LevelType_HowToPlay:
			return howToPlay;
		case LevelType_Lives:
			lives->displayLives(&game->mario);	//We pass Mario here so displayLives knows how many lives to display
			return lives;
		case LevelType_MainGame:
			return game;
		case LevelType_MainMenu:
			return menus;
		case LevelType_GameOver:
			return over;
		case LevelType_TimeUp:
			return up;
		case LevelType_YouWin:
			return win;
	}

	return NULL;
}

void main()
{
	sf::RenderWindow window(sf::VideoMode(1024, 768), "Super Mario Bros. SFML", sf::Style::Close);	//Create a 1024, 768 window with the appropriate window title and the Close style to prevent maximizing and resizing the window
	Input input;	//Create an input object to track user input

	//	//	//	//
	Level::enemyManager = new EnemyManager();
	Level::itemManager = new ItemManager();		//	Create new instances of our managers
	Level::moveablesManager = new MoveablesManager();
	Level::audioManager = new AudioManager();
	//	//	//	//
	
	//	//	//	//
	game = new MainGame(&window, &input);	
	menus = new MainMenu(&window, &input);	
	lives = new Lives(&window, &input);	
	howToPlay = new HowToPlay(&window, &input);		//	Create new instances of our levels
	over = new GameOver(&window, &input);
	up = new TimeUp(&window, &input);
	win = new YouWin(&window, &input);
	//	//	//	//

	Level level(&window, &input);	//Create a new inital level object
	Level::currentLevel = menus;	//Our current level will be the game start, the menus

	sf::Clock clock;	//Create a clock object to get delta time

	// Game loop
	while (window.isOpen())
	{
		sf::Event event;
		while (window.pollEvent(event))
		{
			switch (event.type)
			{
			case sf::Event::Closed:
				window.close();
				break;
			case sf::Event::Resized:
				window.setView(sf::View(sf::FloatRect(0.f, 0.f,
					(float)event.size.width, (float)event.size.height)));
				break;
			case sf::Event::KeyPressed:
				// update input class
				input.setKeyDown(event.key.code);
				break;
			case sf::Event::KeyReleased:
				//update input class
				input.setKeyUp(event.key.code);
				break;
			case sf::Event::MouseMoved:
				//update input class
				input.setMousePosition(event.mouseMove.x,
					event.mouseMove.y);
				break;
			case sf::Event::MouseButtonPressed:
				if (event.mouseButton.button == sf::Mouse::Left)
				{
					//update input class
					input.setMouseLeftDown(true);
				}

				else if (event.mouseButton.button == sf::Mouse::Right)
				{
					//update input class
					input.setMouseRightDown(true);
				}
				break;
			case sf::Event::MouseButtonReleased:
				if (event.mouseButton.button == sf::Mouse::Left)
				{
					//update input class
					input.setMouseLeftDown(false);
				}

				else if (event.mouseButton.button == sf::Mouse::Right)
				{
					//update input class
					input.setMouseRightDown(false);
				}
				break;
			default:
				// don't handle other events
				break;
			}
		}

		float deltaTime = clock.restart().asSeconds();	//Restart the clock to get delta time

		if (!game->isPaused)	//If we're not paused, call our functions as normal
		{
			level.handleInput(deltaTime);
			level.update(deltaTime);
			level.render();
		}

		else    //Else we are paused, so pass dt as 0 to pause all updating and movement of the level
		{
			level.handleInput(0);
			level.update(0);
			level.render();
		}
	}

	//	//	//	//
	delete game;
	delete menus;
	delete lives;
	delete howToPlay;			//When Main returns, we clean up and delete all of our levels and managers
	delete over;
	delete up;
	delete win;
	delete Level::enemyManager;
	delete Level::moveablesManager;
	delete Level::itemManager;
	delete Level::audioManager;
	//	//	//	//
}